// MyFontWrapper.cpp : implementation file
//

#include "stdafx.h"
#include "script.h"
#include "IntrinsicControl.h"
#include "MyFontWrapper.h"

#undef _DEBUG // EMP DIKEO


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyFontWrapper

IMPLEMENT_DYNCREATE(CMyFontWrapper, CCmdTarget)
TCHAR szFontName[255];

CMyFontWrapper::CMyFontWrapper(LPPROPERTYNOTIFYSINK pNotify) : m_FontHolder(pNotify)
{
	EnableAutomation();
	EnableAggregation();

	// allow event connections
	EnableConnections();

	// turn on type library support
	//EnableTypeLib();
	m_pNotify=pNotify;

}

CMyFontWrapper::~CMyFontWrapper()
{
}

void CMyFontWrapper::InitializeFont(const FONTDESC* pFontDesc,
	LPDISPATCH pFontDispAmbient)
{

	m_FontDesc=*pFontDesc;
	_tcscpy(szFontName,pFontDesc->lpstrName);
	m_FontDesc.lpstrName=szFontName;
	m_FontHolder.InitializeFont(pFontDesc,pFontDispAmbient);

	Notify();

}

HFONT CMyFontWrapper::GetFontHandle()
{
	return m_FontHolder.GetFontHandle();
}

void CMyFontWrapper::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CMyFontWrapper, CCmdTarget)
	//{{AFX_MSG_MAP(CMyFontWrapper)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CMyFontWrapper, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CMyFontWrapper)
	DISP_PROPERTY_EX(CMyFontWrapper, "Name", GetName, SetName, VT_BSTR)
	DISP_PROPERTY_EX(CMyFontWrapper, "Size", GetSize, SetSize, VT_I4)
	DISP_PROPERTY_EX(CMyFontWrapper, "Bold", GetBold, SetBold, VT_BOOL)
	DISP_PROPERTY_EX(CMyFontWrapper, "Underline", GetUnderline, SetUnderline, VT_BOOL)
	DISP_PROPERTY_EX(CMyFontWrapper, "Italic", GetItalic, SetItalic, VT_BOOL)
	DISP_PROPERTY_EX(CMyFontWrapper, "Strikethrough", GetStrikethrough, SetStrikethrough, VT_BOOL)
	DISP_PROPERTY_EX(CMyFontWrapper, "Weight", GetWeight, SetWeight, VT_I2)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IMyFontWrapper to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {8CEC83F2-7FDF-11D2-898A-0000E73336C3}
static const IID IID_IMyFontWrapper =
{ 0x8cec83f2, 0x7fdf, 0x11d2, { 0x89, 0x8a, 0x0, 0x0, 0xe7, 0x33, 0x36, 0xc3 } };

BEGIN_INTERFACE_MAP(CMyFontWrapper, CCmdTarget)
	INTERFACE_PART(CMyFontWrapper, IID_IMyFontWrapper, Dispatch)
END_INTERFACE_MAP()

void CMyFontWrapper::Notify(void)
{

	if(m_pNotify)
		m_pNotify->OnChanged(0);
}

/////////////////////////////////////////////////////////////////////////////
// CMyFontWrapper message handlers

BSTR CMyFontWrapper::GetName() 
{
	IFont *pifont=m_FontHolder.m_pFont;;
	BSTR str;


	CString strResult;

	pifont->get_Name(&str);

	return str;
}

void CMyFontWrapper::SetName(LPCTSTR lpszNewValue) 
{
	//IFont *pifont=m_FontHolder.m_pFont;;

	//pifont->put_Name((BSTR)lpszNewValue);
	_tcscpy(szFontName,lpszNewValue);
	m_FontHolder.InitializeFont(&m_FontDesc,NULL);
	Notify();
}

long CMyFontWrapper::GetSize() 
{
	IFont *pifont=m_FontHolder.m_pFont;
	CY cy;

	pifont->get_Size(&cy);
	return cy.Lo/10000;

}

void CMyFontWrapper::SetSize(long nNewValue) 
{
	
	m_FontDesc.cySize.Lo=nNewValue*10000;
	m_FontDesc.cySize.Hi=0;
	m_FontHolder.InitializeFont(&m_FontDesc,NULL);
	Notify();

}


BOOL CMyFontWrapper::GetBold() 
{
	IFont *pifont=m_FontHolder.m_pFont;
	BOOL bBold;

	pifont->get_Bold(&bBold);
	return bBold;
}

void CMyFontWrapper::SetBold(BOOL bNewValue) 
{
	m_FontDesc.sWeight=bNewValue?FW_BOLD:FW_NORMAL;
	m_FontHolder.InitializeFont(&m_FontDesc,NULL);
	Notify();

}

BOOL CMyFontWrapper::GetUnderline() 
{
	IFont *pifont=m_FontHolder.m_pFont;
	BOOL bUnderline;

	pifont->get_Underline(&bUnderline);
	return bUnderline;
}

void CMyFontWrapper::SetUnderline(BOOL bNewValue) 
{
	m_FontDesc.fUnderline=bNewValue;
	m_FontHolder.InitializeFont(&m_FontDesc,NULL);
	Notify();
}

BOOL CMyFontWrapper::GetItalic() 
{
	IFont *pifont=m_FontHolder.m_pFont;
	BOOL bItalic;

	pifont->get_Italic(&bItalic);
	return bItalic;
}

void CMyFontWrapper::SetItalic(BOOL bNewValue) 
{
	m_FontDesc.fItalic=bNewValue;
	m_FontHolder.InitializeFont(&m_FontDesc,NULL);
	Notify();
}

BOOL CMyFontWrapper::GetStrikethrough() 
{
	IFont *pifont=m_FontHolder.m_pFont;
	BOOL bStrike;

	pifont->get_Strikethrough(&bStrike);
	return bStrike;
}

void CMyFontWrapper::SetStrikethrough(BOOL bNewValue) 
{
	m_FontDesc.fStrikethrough=bNewValue;
	m_FontHolder.InitializeFont(&m_FontDesc,NULL);
	Notify();
}

short CMyFontWrapper::GetWeight() 
{
	IFont *pifont=m_FontHolder.m_pFont;
	short sWeight;

	pifont->get_Weight(&sWeight);
	return sWeight;

}

void CMyFontWrapper::SetWeight(short nNewValue) 
{
	m_FontDesc.sWeight=nNewValue;
	if (m_FontDesc.sWeight>550)
		m_FontDesc.sWeight=700;
	else
		m_FontDesc.sWeight=400;

	m_FontHolder.InitializeFont(&m_FontDesc,NULL);
	Notify();
}
